// 最小化测试扩展
const vscode = require('vscode');

// 激活函数 - 必须导出
exports.activate = function(context) {
    console.log('=== MINIMAL EXTENSION ACTIVATED ===');
    console.log('This should appear in debug console');
    
    // 显示通知
    vscode.window.showInformationMessage('Minimal extension activated!');
    
    // 注册命令
    let disposable = vscode.commands.registerCommand('minimal-test.hello', function() {
        vscode.window.showInformationMessage('Hello from minimal extension!');
    });
    
    context.subscriptions.push(disposable);
};

// 停用函数 - 可选
exports.deactivate = function() {
    console.log('Minimal extension deactivated');
};