"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.activate = activate;
exports.deactivate = deactivate;
const vscode = __importStar(require("vscode"));
// 插件激活入口
function activate(context) {
    console.log('✅ Copy Word at Cursor 扩展已激活');
    // 显示激活提示
    vscode.window.showInformationMessage('Copy Word at Cursor 扩展已激活', { modal: false });
    // 监听文本选择变化（光标位置变化）
    const disposable = vscode.window.onDidChangeTextEditorSelection((event) => {
        if (!event.textEditor || event.selections.length === 0) {
            return;
        }
        const position = event.selections[0].active;
        const document = event.textEditor.document;
        // 尝试获取单词
        const wordRange = document.getWordRangeAtPosition(position);
        if (wordRange) {
            // 有单词，复制单词
            const word = document.getText(wordRange);
            if (word.trim()) {
                copyToClipboard(word, '单词');
            }
        }
        else {
            // 没有单词，尝试获取单个字符
            const charRange = new vscode.Range(position, position.translate(0, 1));
            if (charRange.end.character <= document.lineAt(position.line).text.length) {
                const char = document.getText(charRange);
                if (char.trim()) {
                    copyToClipboard(char, '字符');
                }
            }
        }
    });
    context.subscriptions.push(disposable);
    // 添加命令：手动复制当前光标位置的单词
    const copyCommand = vscode.commands.registerCommand('copy-word-at-cursor.copy', () => {
        const editor = vscode.window.activeTextEditor;
        if (!editor || editor.selections.length === 0) {
            return;
        }
        const position = editor.selections[0].active;
        const document = editor.document;
        const wordRange = document.getWordRangeAtPosition(position);
        if (wordRange) {
            const word = document.getText(wordRange);
            if (word.trim()) {
                copyToClipboard(word, '单词');
            }
        }
    });
    context.subscriptions.push(copyCommand);
}
// 复制到剪贴板
function copyToClipboard(text, type) {
    vscode.env.clipboard.writeText(text).then(() => {
        // 可选：显示简短提示
        // vscode.window.showInformationMessage(`已复制${type}：${text}`, { modal: false });
        console.log(`✅ 已复制${type}：${text}`);
    }, (err) => {
        console.error(`❌ 复制失败：${err.message}`);
    });
}
// 插件停用
function deactivate() {
    console.log('Copy Word at Cursor 扩展已停用');
}
//# sourceMappingURL=extension.js.map