// 最简单的扩展测试
console.log('=== 简单扩展测试开始 ===');

// 检查当前目录
const fs = require('fs');
const path = require('path');

console.log('当前目录:', __dirname);
console.log('扩展文件:', path.join(__dirname, 'out/extension.js'));

// 读取扩展文件
try {
  const extPath = path.join(__dirname, 'out/extension.js');
  const stats = fs.statSync(extPath);
  console.log(`文件大小: ${stats.size} 字节`);
  
  // 读取前500个字符
  const content = fs.readFileSync(extPath, 'utf8', 0, 500);
  console.log('\n文件开头内容:');
  console.log(content.substring(0, 500));
  
  // 检查是否包含激活函数
  if (content.includes('activate')) {
    console.log('\n✅ 文件中包含 activate 函数');
  } else {
    console.log('\n❌ 文件中不包含 activate 函数');
  }
  
  if (content.includes('showInformationMessage')) {
    console.log('✅ 文件中包含 showInformationMessage');
  }
  
} catch (error) {
  console.log('❌ 读取文件失败:', error.message);
}

console.log('\n=== 测试结束 ===');