// 简单测试扩展是否工作
console.log('测试脚本开始...\n');

// 首先检查文件是否存在
const fs = require('fs');
const path = require('path');

console.log('检查文件:');
console.log('- extension.js 存在:', fs.existsSync(path.join(__dirname, 'out/extension.js')));
console.log('- extension.js 大小:', fs.statSync(path.join(__dirname, 'out/extension.js')).size, 'bytes');

// 尝试直接读取和显示扩展文件的前几行
console.log('\n扩展文件内容预览:');
try {
  const content = fs.readFileSync(path.join(__dirname, 'out/extension.js'), 'utf8');
  const lines = content.split('\n').slice(0, 10);
  console.log(lines.join('\n'));
  console.log('...');
} catch (error) {
  console.log('读取文件失败:', error.message);
}

// 尝试加载扩展
console.log('\n尝试加载扩展模块:');
try {
  // 清除缓存
  delete require.cache[require.resolve('./out/extension')];
  
  const extension = require('./out/extension');
  console.log('✅ 扩展模块加载成功');
  
  // 检查导出
  console.log('检查导出:');
  console.log('- activate:', typeof extension.activate);
  console.log('- deactivate:', typeof extension.deactivate);
  
  // 模拟简单的激活
  console.log('\n模拟激活:');
  const mockContext = {
    subscriptions: []
  };
  
  if (typeof extension.activate === 'function') {
    console.log('调用 activate...');
    extension.activate(mockContext);
    console.log('activate 调用完成');
  }
  
} catch (error) {
  console.log('❌ 加载扩展失败:');
  console.log('错误:', error.message);
  console.log('堆栈:', error.stack);
}

console.log('\n测试完成');